/**
* jQuery.smoothDivScroll - Smooth div scrolling using jQuery.
* This plugin is for turning a set of HTML elements's into a smooth scrolling area.
*
* Copyright (c) 2009 Thomas Kahn - thomas.kahn(at)karnhuset(dot)net
*
* This plugin is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This plugin is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details. <http://www.gnu.org/licenses/>.
*
* Date: 2009-07-05
* @author Thomas Kahn
* @version 0.9
*
* Changelog
* ---------------------------------------------
* 0.9	- Bugfixes: Problem with multiple autoscrollers on the same page - the intervals
*		  where global which resulted in the wrong autoscroller stopping on mouseOver or
*		  mouseDown.
*		  Error in calculation in autoscrolling mode that made the autoscrolling grind
*		  to a halt after a number of loops.
*
* 0.8   - Major update. New parameter setup. Lots of new autoscrolling capabilities and 
*		  new parameters for controlling the scrolling speed. Made it possible to start 
*		  the scroller at a specific element.
* 
* 0.7   - Added support for autoscrolling after the page has loaded. 
*         Added support for making the hot spots visible at start for X number of seconds
*         or visible all the time.
*
* 0.6   - First version.
*/

(function($scroll){jQuery.fn.smoothDivScroll=function(options){var defaults={scrollingHotSpotLeft:"div.scrollingHotSpotLeft",scrollingHotSpotRight:"div.scrollingHotSpotRight",scrollWrapper:"div.scrollWrapper",scrollableArea:"div.scrollableArea",hiddenOnStart:false,ajaxContentURL:"",countOnlyClass:"",scrollingSpeed:25,mouseDownSpeedBooster:3,autoScroll:"",autoScrollDirection:"right",autoScrollSpeed:1,pauseAutoScroll:"",visibleHotSpots:"",hotSpotsVisibleTime:5,startAtElementId:""};options=$scroll.extend(defaults,options);return this.each(function(){var $scrollmom=$scroll(this);if(options.ajaxContentURL.length!==0){$scrollmom.scrollableAreaWidth=0;$scrollmom.find(options.scrollableArea).load((options.ajaxContentURL),function(){$scrollmom.find(options.scrollableArea).children((options.countOnlyClass)).each(function(){$scrollmom.scrollableAreaWidth=$scrollmom.scrollableAreaWidth+$scroll(this).outerWidth(true);});$scrollmom.find(options.scrollableArea).css("width",($scrollmom.scrollableAreaWidth+"px"));if(options.hiddenOnStart){$scrollmom.hide();}
windowIsResized();setHotSpotHeightForIE();});}
var scrollXpos;var booster;var motherElementOffset=$scrollmom.offset().left;var hotSpotWidth=0;booster=1;var hasExtended=false;$scroll(window).one("load",function(){if(options.ajaxContentURL.length===0){$scrollmom.scrollableAreaWidth=0;$scrollmom.tempStartingPosition=0;$scrollmom.find(options.scrollableArea).children((options.countOnlyClass)).each(function(){if((options.startAtElementId.length!==0)&&(($scroll(this).attr("id"))==options.startAtElementId)){$scrollmom.tempStartingPosition=$scrollmom.scrollableAreaWidth;}
$scrollmom.scrollableAreaWidth=$scrollmom.scrollableAreaWidth+$scroll(this).outerWidth(true);});$scrollmom.find(options.scrollableArea).css("width",$scrollmom.scrollableAreaWidth+"px");if(options.hiddenOnStart){$scrollmom.hide();}}
$scrollmom.find(options.scrollWrapper).scrollLeft($scrollmom.tempStartingPosition);if(options.autoScroll!==""){$scrollmom.autoScrollInterval=setInterval(autoScroll,6);}
if(options.autoScroll=="always")
{hideLeftHotSpot();hideRightHotSpot();}
switch(options.visibleHotSpots)
{case"always":makeHotSpotBackgroundsVisible();break;case"onstart":makeHotSpotBackgroundsVisible();$scrollmom.hideHotSpotBackgroundsInterval=setInterval(hideHotSpotBackgrounds,(options.hotSpotsVisibleTime*1000));break;default:break;}});$scrollmom.find(options.scrollingHotSpotRight,options.scrollingHotSpotLeft).one('mouseover',function(){if(options.autoScroll=="onstart"){clearInterval($scrollmom.autoScrollInterval);}});$scroll(window).bind("resize",function(){windowIsResized();});function windowIsResized(){if(!(options.hiddenOnStart))
{$scrollmom.scrollableAreaWidth=0;$scrollmom.find(options.scrollableArea).children((options.countOnlyClass)).each(function(){$scrollmom.scrollableAreaWidth=$scrollmom.scrollableAreaWidth+$scroll(this).outerWidth(true);});$scrollmom.find(options.scrollableArea).css("width",$scrollmom.scrollableAreaWidth+'px');}
$scrollmom.find(options.scrollWrapper).scrollLeft("0");var bodyWidth=$scroll("body").innerWidth();if(options.autoScroll!=="always")
{if($scrollmom.scrollableAreaWidth<bodyWidth)
{hideLeftHotSpot();hideRightHotSpot();}
else
{showHideHotSpots();}}}
function hideLeftHotSpot(){$scrollmom.find(options.scrollingHotSpotLeft).hide();}
function hideRightHotSpot(){$scrollmom.find(options.scrollingHotSpotRight).hide();}
function showLeftHotSpot(){$scrollmom.find(options.scrollingHotSpotLeft).show();if(hotSpotWidth<=0){hotSpotWidth=$scrollmom.find(options.scrollingHotSpotLeft).width();}}
function showRightHotSpot(){$scrollmom.find(options.scrollingHotSpotRight).show();if(hotSpotWidth<=0){hotSpotWidth=$scrollmom.find(options.scrollingHotSpotRight).width();}}
function setHotSpotHeightForIE()
{jQuery.each(jQuery.browser,function(i,val){if(i=="msie"&&jQuery.browser.version.substr(0,1)=="6")
{$scrollmom.find(options.scrollingHotSpotLeft).css("height",($scrollmom.find(options.scrollableArea).innerHeight()));$scrollmom.find(options.scrollingHotSpotRight).css("height",($scrollmom.find(options.scrollableArea).innerHeight()));}});}
$scrollmom.find(options.scrollingHotSpotRight).bind('mousemove',function(e){var x=e.pageX-(this.offsetLeft+motherElementOffset);scrollXpos=Math.round((x/hotSpotWidth)*options.scrollingSpeed);if(scrollXpos===Infinity){scrollXpos=0;}});$scrollmom.find(options.scrollingHotSpotRight).bind('mouseover',function(){if(options.autoScroll=="onstart"){clearInterval($scrollmom.autoScrollInterval);}
$scrollmom.rightScrollInterval=setInterval(doScrollRight,6);});$scrollmom.find(options.scrollingHotSpotRight).bind('mouseout',function(){clearInterval($scrollmom.rightScrollInterval);scrollXpos=0;});$scrollmom.find(options.scrollingHotSpotRight).bind('mousedown',function(){booster=options.mouseDownSpeedBooster;});$scroll("*").bind('mouseup',function(){booster=1;});var doScrollRight=function()
{if(scrollXpos>0){$scrollmom.find(options.scrollWrapper).scrollLeft($scrollmom.find(options.scrollWrapper).scrollLeft()+(scrollXpos*booster));}
showHideHotSpots();};if(options.pauseAutoScroll=="mousedown"&&options.autoScroll=="always")
{$scrollmom.find(options.scrollWrapper).bind('mousedown',function(){clearInterval($scrollmom.autoScrollInterval);});$scrollmom.find(options.scrollWrapper).bind('mouseup',function(){$scrollmom.autoScrollInterval=setInterval(autoScroll,6);});}
else if(options.pauseAutoScroll=="mouseover"&&options.autoScroll=="always")
{$scrollmom.find(options.scrollWrapper).bind('mouseover',function(){clearInterval($scrollmom.autoScrollInterval);});$scrollmom.find(options.scrollWrapper).bind('mouseout',function(){$scrollmom.autoScrollInterval=setInterval(autoScroll,6);});}
$scrollmom.previousScrollLeft=0;$scrollmom.pingPongDirection="right";$scrollmom.swapAt;$scrollmom.getNextElementWidth=true;var autoScroll=function()
{if(options.autoScroll=="onstart"){showHideHotSpots();}
switch(options.autoScrollDirection)
{case"right":$scrollmom.find(options.scrollWrapper).scrollLeft($scrollmom.find(options.scrollWrapper).scrollLeft()+options.autoScrollSpeed);break;case"left":$scrollmom.find(options.scrollWrapper).scrollLeft($scrollmom.find(options.scrollWrapper).scrollLeft()-options.autoScrollSpeed);break;case"backandforth":$scrollmom.previousScrollLeft=$scrollmom.find(options.scrollWrapper).scrollLeft();if($scrollmom.pingPongDirection=="right"){$scrollmom.find(options.scrollWrapper).scrollLeft($scrollmom.find(options.scrollWrapper).scrollLeft()+options.autoScrollSpeed);}
else{$scrollmom.find(options.scrollWrapper).scrollLeft($scrollmom.find(options.scrollWrapper).scrollLeft()-options.autoScrollSpeed);}
if($scrollmom.previousScrollLeft===$scrollmom.find(options.scrollWrapper).scrollLeft())
{if($scrollmom.pingPongDirection=="right"){$scrollmom.pingPongDirection="left";}
else{$scrollmom.pingPongDirection="right";}}
break;case"endlessloop":if($scrollmom.getNextElementWidth)
{if(options.startAtElementId!==""){$scrollmom.swapAt=$scroll("#"+options.startAtElementId).outerWidth();}
else{$scrollmom.swapAt=$scrollmom.find(options.scrollableArea).children(":first-child").outerWidth();}
$scrollmom.getNextElementWidth=false;}
$scrollmom.find(options.scrollWrapper).scrollLeft($scrollmom.find(options.scrollWrapper).scrollLeft()+options.autoScrollSpeed);if(($scrollmom.swapAt<=$scrollmom.find(options.scrollWrapper).scrollLeft()))
{$scrollmom.find(options.scrollableArea).append($scrollmom.find(options.scrollableArea).children(":first-child").clone());$scrollmom.find(options.scrollWrapper).scrollLeft(($scrollmom.find(options.scrollWrapper).scrollLeft()-$scrollmom.find(options.scrollableArea).children(":first-child").outerWidth()));$scrollmom.find(options.scrollableArea).children(":first-child").remove();$scrollmom.getNextElementWidth=true;}
break;default:break;}};$scrollmom.find(options.scrollingHotSpotLeft).bind('mousemove',function(e){var x=$scrollmom.find(options.scrollingHotSpotLeft).innerWidth()-(e.pageX-motherElementOffset);scrollXpos=Math.round((x/hotSpotWidth)*options.scrollingSpeed);if(scrollXpos===Infinity)
{scrollXpos=0;}});$scrollmom.find(options.scrollingHotSpotLeft).bind('mouseover',function(){if(options.autoScroll=="onstart"){clearInterval($scrollmom.autoScrollInterval);}
$scrollmom.leftScrollInterval=setInterval(doScrollLeft,6);});$scrollmom.find(options.scrollingHotSpotLeft).bind('mouseout',function(){clearInterval($scrollmom.leftScrollInterval);scrollXpos=0;});$scrollmom.find(options.scrollingHotSpotLeft).bind('mousedown',function(){booster=options.mouseDownSpeedBooster;});var doScrollLeft=function()
{if(scrollXpos>0){$scrollmom.find(options.scrollWrapper).scrollLeft($scrollmom.find(options.scrollWrapper).scrollLeft()-(scrollXpos*booster));}
showHideHotSpots();};function showHideHotSpots()
{if($scrollmom.find(options.scrollWrapper).scrollLeft()===0)
{hideLeftHotSpot();showRightHotSpot();}
else if(($scrollmom.scrollableAreaWidth)<=($scrollmom.find(options.scrollWrapper).innerWidth()+$scrollmom.find(options.scrollWrapper).scrollLeft()))
{hideRightHotSpot();showLeftHotSpot();}
else
{showRightHotSpot();showLeftHotSpot();}}
function makeHotSpotBackgroundsVisible()
{$scrollmom.find(options.scrollingHotSpotLeft).addClass("scrollingHotSpotLeftVisible");$scrollmom.find(options.scrollingHotSpotRight).addClass("scrollingHotSpotRightVisible");}
function hideHotSpotBackgrounds()
{clearInterval($scrollmom.hideHotSpotBackgroundsInterval);$scrollmom.find(options.scrollingHotSpotLeft).fadeTo("slow",0.0,function(){$scrollmom.find(options.scrollingHotSpotLeft).removeClass("scrollingHotSpotLeftVisible");});$scrollmom.find(options.scrollingHotSpotRight).fadeTo("slow",0.0,function(){$scrollmom.find(options.scrollingHotSpotRight).removeClass("scrollingHotSpotRightVisible");});}});};})(jQuery);