<?php

// Mini Slider Widget

add_action( 'widgets_init', 'mini_slider_widgets' );

function mini_slider_widgets() {
	register_widget( 'Mini_Slider' );
}

class Mini_Slider extends WP_Widget {
	function Mini_Slider() {

		$widget_ops = array( 'classname' => 'mini_slider', 'description' => 'Display mini slider' );

		$this->WP_Widget( 'mini_slider-widget', 'GP Mini Slider', $widget_ops);
	}

	function widget( $args, $instance ) {
		global $post;
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		$display = $instance['display'];

		$r = new WP_Query(array('posts_per_page' => -1, 'meta_key' => 'mini_slider', 'meta_value' => get_post_meta($post->ID, 'mini_slider', true), 'post_status' => 'publish', 'caller_get_posts' => 1)); if ($r->have_posts()) : ?>
		
		<?php echo $before_widget; ?>
		<?php if ( $title ) echo $before_title . $title . $after_title; ?>
		<div id="minislider">
			<div id="minisliderContent">			
				<?php while ($r->have_posts()) : $r->the_post(); ?>
				<div class="minisliderImage">
					<a href="<?php the_permalink(); ?>">
					<?php if(function_exists('add_theme_support') && has_post_thumbnail()) { ?>
						<?php the_post_thumbnail(('sidebar-image'), array('title' => '')); ?>				
					<?php } else { ?>
						<img src="<?php echo get_post_meta($post->ID, 'slider_image', true); ?>" alt="" />
					<?php } ?>
					</a>
					<span class="<?php if($instance['display'] == 'bottom') { ?>cap-bottom<?php } elseif($instance['display'] == 'top') { ?>cap-top<?php } ?>"<?php if($instance['display'] == 'disable') { ?> style="visibility: hidden;"<?php } ?>>
						<?php excerpt('15'); ?>									
					</span>
				</div>
				<?php endwhile; ?>
				<div class="clear minisliderImage"></div>
			</div>
		</div>	
	<?php else : ?>
		<?php echo $before_widget; ?>
	<?php endif; echo $after_widget; wp_reset_query(); 
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['display'] = $_POST['display'];
		return $instance;
	}

	function form( $instance ) {

		$defaults = array( 'title' => '');
		$defaults = array( 'display' => 'Bottom');
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
			<br/><input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
		<p>
			<label for="display">Caption Position:</label>
			<select id="display" name="display">
                <option value="bottom" <?php if ($instance['display'] == 'bottom'){ echo 'selected="selected"'; } ?> >Bottom</option>
				<option value="top" <?php if ($instance['display'] == 'top'){ echo 'selected="selected"'; } ?> >Top</option>
				<option value="disable" <?php if ($instance['display'] == 'disable'){ echo 'selected="selected"'; } ?> >Disable</option>    				
			</select>
			<input type="hidden" name="blogs-submit" id="blogs-submit" value="1" />
		</p>

		<?php
	}

}



// Custom Content Widget

add_action( 'widgets_init', 'custom_content_widgets' );

function custom_content_widgets() {
	register_widget( 'Custom_Content' );
}

class Custom_Content extends WP_Widget {
	function Custom_Content() {

		$widget_ops = array( 'classname' => 'custom_content', 'description' => 'Display custom content such as Google ads, flash and javascript.' );
		$control_ops = array('width' => 300);

		$this->WP_Widget( 'custom_content-widget', 'GP Custom Content', $widget_ops, $control_ops);
	}

	function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		$content = $instance['content']; ?>
		
		<?php echo $before_widget; ?>
		<?php if ( $title ) echo $before_title . $title . $after_title; ?>
		<?php echo $content ?>
		
	<?php echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['content'] = ( $new_instance['content'] );
		return $instance;
	}

	function form( $instance ) {

		$defaults = array( 'title' => '');
		$defaults = array( 'content' => '');
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
			<br/><input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'content' ); ?>">Content:</label>
			<textarea style="width: 300px; height: 250px;" id="<?php echo $this->get_field_id( 'content' ); ?>" name="<?php echo $this->get_field_name( 'content' ); ?>"><?php echo $instance['content']; ?></textarea>
		</p>

		<?php
	}

}



// Recent Comments Widget

add_action( 'widgets_init', 'recent_comments_widgets' );

function recent_comments_widgets() {
	register_widget( 'Recent_Comments' );
}
class Recent_Comments extends WP_Widget {
	function Recent_Comments() {

		$widget_ops = array( 'classname' => 'recent_comments', 'description' => 'Displays recent comments with avatars and comment excerpts.' );

		$this->WP_Widget( 'recent-comments', 'GP Recent Comments', $widget_ops);
	}

	function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		$number = $instance['number'];
	?>
<?php echo $before_widget; ?>
<?php if ( $title ) echo $before_title . $title . $after_title; ?>
<div id="recent-comments">
	<ul>
		<?php 
		global $wpdb;
		$request = "SELECT * FROM $wpdb->comments";
		$request .= " JOIN $wpdb->posts ON ID = comment_post_ID";
		$request .= " WHERE comment_approved = '1' AND post_status = 'publish' AND post_password =''";
		$request .= " ORDER BY comment_date DESC LIMIT $number";
		$comments = $wpdb->get_results($request);
		if ($comments) {
			foreach ($comments as $comment) {
				ob_start();
				?>
					<li>
						<?php echo get_avatar($comment,$size='40'); ?>
						<div class="text">
							<a href="<?php echo get_permalink( $comment->comment_post_ID ) . '#comment-' . $comment->comment_ID; ?>"><?php echo strip_tags(substr(apply_filters('get_comment_text', $comment->comment_content), 0, 35)); ?>...</a>
							<span><?php echo get_the_author($comment); ?> on
							<?php echo post_title(get_the_title($comment->comment_post_ID)) ?></span>
						</div>
						<div class="clear"></div>
					</li>
				<?php
				ob_end_flush();
			}
		} else {
			echo '<li>'.__('No comments', 'banago').'</li>';
		}
	
	?>
	</ul>
</div>
<?php
	echo $after_widget;
	wp_reset_query(); 
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['number'] = strip_tags( $new_instance['number'] );

		return $instance;
	}

	function form( $instance ) {

		$defaults = array( 'title' => '');
		$defaults = array( 'number' => '5');
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
			<br/><input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>">Number of Comments:</label>
			<input type="text" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" size="3" value="<?php echo $instance['number']; ?>" />
		</p>		
		
		<?php
	}

}


// Post Display Widget

add_action( 'widgets_init', 'post_display_widgets' );

function post_display_widgets() {
	register_widget('Post_Display');
}

class Post_Display extends WP_Widget {
	function Post_Display() {

		$widget_ops = array( 'classname' => 'post_display', 'description' => 'Display posts in a variety of ways.');

		$this->WP_Widget( 'post_display-widget', 'GP Post Display', $widget_ops);
	}

	function widget( $args, $instance ) {
		global $post;
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		$number = $instance['number'];
		$cat = $instance['cat'];
		$orderby = $instance['orderby'];
		$order = $instance['order'];

		$r = new WP_Query(array('cat' => $cat, 'posts_per_page' => $number, 'orderby' => $orderby, 'order' => $order, 'nopaging' => 0, 'post_status' => 'publish', 'caller_get_posts' => 1));

		if ($r->have_posts()) :
		?>
		<?php echo $before_widget; ?>
		
		<div id="post-display-widget">
		
			<?php if ( $title ) echo $before_title . $title . $after_title; ?>
			<?php while ($r->have_posts()) : $r->the_post(); ?>
			
			<div class="post-display">
				
				<div class="post-display-image">
					<a href="<?php the_permalink(); ?>">
					<?php if(function_exists('add_theme_support') && has_post_thumbnail()) { ?>
						<?php the_post_thumbnail(('sidebar-image'), array('title' => '')); ?>				
					<?php } else { ?>
						<img src="<?php echo get_post_meta($post->ID, 'slider_image', true); ?>" alt="" />
					<?php } ?>
					</a>
				</div>
				
				<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
				
				<?php excerpt('10'); ?> <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">Continue &raquo;</a>
	
			</div>
			
			<?php endwhile; ?>
			
		</div>
		
	<?php endif; echo $after_widget; wp_reset_query(); 
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['cat'] = strip_tags( $new_instance['cat'] );
		$instance['number'] = $new_instance['number'];
		$instance['orderby'] = $_POST['orderby'];	
		$instance['order'] = $_POST['order'];	
		return $instance;
	}

	function form( $instance ) {

		$defaults = array( 'title' => '', 'cat' => '', 'number' => 2, 'orderby' => 'date', 'order' => 'desc');
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
			<br/><input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'cat' ); ?>">Category IDs:</label>
			<br/><input type="text" id="<?php echo $this->get_field_id( 'cat' ); ?>" name="<?php echo $this->get_field_name( 'cat' ); ?>" value="<?php echo $instance['cat']; ?>" />
			<br/><small>Type the IDs of the categories you want to include, separating each with a comma (e.g. 23,51,102,65), leave blank to display all</small>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>">Number of posts to show:</label>
			<input  type="text" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" value="<?php echo $instance['number']; ?>" size="3" />
		</p>
		<p>
			<label for="orderby">Order By:</label>
			<select id="orderby" name="orderby">
				<option value="date" <?php if ($instance['orderby'] == 'date'){ echo 'selected="selected"'; } ?> >Date</option>			
				<option value="title" <?php if ($instance['orderby'] == 'title'){ echo 'selected="selected"'; } ?> >Post Title</option> 			
                <option value="comment_count" <?php if ($instance['orderby'] == 'comment_count'){ echo 'selected="selected"'; } ?> >Comments</option>
				<option value="rand" <?php if ($instance['orderby'] == 'rand'){ echo 'selected="selected"'; } ?> >Random</option>    				
			</select>
		</p>
		<p>
			<label for="order">Order:</label>
			<select id="order" name="order">
				<option value="desc" <?php if ($instance['order'] == 'desc'){ echo 'selected="selected"'; } ?> >Descending</option> 			
				<option value="asc" <?php if ($instance['order'] == 'asc'){ echo 'selected="selected"'; } ?> >Ascending</option>							
			</select>
		</p>
		<input type="hidden" name="blogs-submit" id="blogs-submit" value="1" />
	<?php }} ?>