<?php // Post & Page Custom Options (WPShout.com)

add_action( 'admin_menu', 'hybrid_create_meta_box' );
add_action( 'save_post', 'hybrid_save_meta_data' );

function hybrid_create_meta_box() {
	global $theme_name;

	add_meta_box( 'post-meta-boxes', __('Additional Options'), 'post_meta_boxes', 'post', 'normal', 'high' );
	add_meta_box( 'page-meta-boxes', __('Additional Options'), 'page_meta_boxes', 'page', 'normal', 'high' );
}

function hybrid_post_meta_boxes() {

	$meta_boxes = array(
	
		'post_template' => array( 'name' => 'post_template', 'title' => __('Post Template', 'hybrid'), 'desc' => '', 'options' => array('Default', 'Full Width', 'Two Columns'), 'type' => 'select'),
		
		'thumbnail' => array( 'name' => 'thumbnail', 'title' => __('Thumbnail URL', 'hybrid'), 'desc' => 'By default the thumbnail will be cropped from the image you upload to this post, however if you want to use a separate image for the thumbnail enter your own image URL (e.g. http://www.example.com/image.jpg).', 'type' => 'text' ),
		
		'featured' => array( 'name' => 'featured', 'title' => __('Featured Post', 'hybrid'), 'desc' => 'Checking this displays the post under the Featured tab on the index page and in the alternative category header if it is the latest post assigned to that category', 'type' => 'checkbox' ),		
		
		'slider' => array( 'name' => 'slider', 'title' => __('Main Slider', 'hybrid'), 'desc' => 'Checking this displays this post in the slider', 'type' => 'checkbox' ),
		
		'mini_slider' => array( 'name' => 'mini_slider', 'title' => __('Mini Slider', 'hybrid'), 'desc' => 'Checking this displays this post in the mini slider widget', 'type' => 'checkbox' ),	
	);

	return apply_filters( 'hybrid_post_meta_boxes', $meta_boxes );
}

function hybrid_page_meta_boxes() {

	$meta_boxes = array(
	
		'subtitle' => array( 'name' => 'subtitle', 'title' => __('Page Subtitle', 'hybrid'), 'desc' => 'Enter the text for your page subtitle.', 'type' => 'text' ),
		
		'thumbnail' => array( 'name' => 'thumbnail', 'title' => __('Thumbnail URL', 'hybrid'), 'desc' => 'By default the thumbnail will be cropped from the image you upload to this post, however if you want to use a separate image for the thumbnail enter your own image URL (e.g. http://www.example.com/image.jpg).', 'type' => 'text' ),
		
		'slider' => array( 'name' => 'slider', 'title' => __('Main Slider', 'hybrid'), 'desc' => 'Checking this displays this page in the slider', 'type' => 'checkbox' ),
		
		'mini_slider' => array( 'name' => 'mini_slider', 'title' => __('Mini Slider', 'hybrid'), 'desc' => 'Checking this displays this page in the mini slider widget', 'type' => 'checkbox' ),
		
		'blog_cats' => array( 'name' => 'blog_cats', 'title' => __('Blog Categories', 'hybrid'), 'desc' => 'If you are using the Blog page template you can enter the IDs of the posts you want to display (e.g. 25,56,7,10).', 'type' => 'text' ),
		
		'port_cats' => array( 'name' => 'port_cats', 'title' => __('Portfolio Categories', 'hybrid'), 'desc' => 'If you are using the Portfolio page template you can enter the IDs of the categories you want to display images from here (e.g. 25,56,7,10).', 'type' => 'text' ),	
		
	);

	return apply_filters( 'hybrid_page_meta_boxes', $meta_boxes );
}

function post_meta_boxes() {
	global $post;
	$meta_boxes = hybrid_post_meta_boxes(); ?>

	<table class="form-table">
	<?php foreach ( $meta_boxes as $meta ) :

		$value = get_post_meta( $post->ID, $meta['name'], true );

		if ( $meta['type'] == 'text' )
			get_meta_text_input( $meta, $value );
		elseif ( $meta['type'] == 'textarea' )
			get_meta_textarea( $meta, $value );
		elseif ( $meta['type'] == 'select' )
			get_meta_select( $meta, $value );
		elseif ( $meta['type'] == 'checkbox' )
			get_meta_checkbox( $meta, $value );			

	endforeach; ?>
	</table>
<?php
}

function page_meta_boxes() {
	global $post;
	$meta_boxes = hybrid_page_meta_boxes(); ?>

	<table class="form-table">
	<?php foreach ( $meta_boxes as $meta ) :

		$value = stripslashes( get_post_meta( $post->ID, $meta['name'], true ) );

		if ( $meta['type'] == 'text' )
			get_meta_text_input( $meta, $value );
		elseif ( $meta['type'] == 'textarea' )
			get_meta_textarea( $meta, $value );
		elseif ( $meta['type'] == 'select' )
			get_meta_select( $meta, $value );
		elseif ( $meta['type'] == 'checkbox' )
			get_meta_checkbox( $meta, $value );			

	endforeach; ?>
	</table>
<?php
}

function get_meta_text_input( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:10%;">
			<label for="<?php echo $name; ?>"><?php echo $title; ?></label>
		</th>
		<td>
			<input type="text" name="<?php echo $name; ?>" id="<?php echo $name; ?>" value="<?php echo wp_specialchars( $value, 1 ); ?>" size="30" tabindex="30" style="width: 97%;" />
			<br/><small><?php echo $desc; ?></small>
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}

function get_meta_select( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:10%;">
			<label for="<?php echo $name; ?>"><?php echo $title; ?></label>
		</th>
		<td>
			<select name="<?php echo $name; ?>" id="<?php echo $name; ?>">
			<?php foreach ( $options as $option ) : ?>
				<option <?php if ( htmlentities( $value, ENT_QUOTES ) == $option ) echo ' selected="selected"'; ?>>
					<?php echo $option; ?>
				</option>
			<?php endforeach; ?>
			</select>
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}

function get_meta_textarea( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:10%;">
			<label for="<?php echo $name; ?>"><?php echo $title; ?></label>
		</th>
		<td>
			<textarea name="<?php echo $name; ?>" id="<?php echo $name; ?>" cols="60" rows="4" tabindex="30" style="width: 97%;"><?php echo wp_specialchars( $value, 1 ); ?></textarea>
			<br/><small><?php echo $desc; ?></small>
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}

function get_meta_checkbox( $args = array(), $value = false ) {

	extract( $args ); ?>
	<tr>
		<th style="width:10%;">
			<label for="<?php echo $name; ?>"><?php echo $title; ?></label>
		</th>
		<td>
		<?php if( wp_specialchars($value, 1 ) ){ $checked = "checked=\"checked\""; } else { if ( $std === "true" ){ $checked = "checked=\"checked\""; } else { $checked = ""; } } ?>
			<input type="checkbox" name="<?php echo $name; ?>" id="<?php echo $name; ?>" value="false" <?php echo $checked; ?> />
			<small><?php echo $desc; ?></small>
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />			
		</td>
	</tr>
	<?php 
}

function hybrid_save_meta_data( $post_id ) {
	global $post;

	if ( 'page' == $_POST['post_type'] )
		$meta_boxes = array_merge( hybrid_page_meta_boxes() );
	else
		$meta_boxes = array_merge( hybrid_post_meta_boxes() );

	foreach ( $meta_boxes as $meta_box ) :

		if ( !wp_verify_nonce( $_POST[$meta_box['name'] . '_noncename'], plugin_basename( __FILE__ ) ) )
			return $post_id;

		if ( 'page' == $_POST['post_type'] && !current_user_can( 'edit_page', $post_id ) )
			return $post_id;

		elseif ( 'post' == $_POST['post_type'] && !current_user_can( 'edit_post', $post_id ) )
			return $post_id;

		$data = stripslashes( $_POST[$meta_box['name']] );

		if ( get_post_meta( $post_id, $meta_box['name'] ) == '' )
			add_post_meta( $post_id, $meta_box['name'], $data, true );

		elseif ( $data != get_post_meta( $post_id, $meta_box['name'], true ) )
			update_post_meta( $post_id, $meta_box['name'], $data );

		elseif ( $data == '' )
			delete_post_meta( $post_id, $meta_box['name'], get_post_meta( $post_id, $meta_box['name'], true ) );

	endforeach;
}
?>