<?php // Themes Options Menu

$themename = "Magnifizine";
$shortname = "theme";
$options = array (

array(	"name" => "General Settings",
      	"type" => "title"),

		array(	"type" => "open",
      	"id" => $shortname."_general"),

		array(  
		"name" => "Theme Skin",
        "desc" => "Choose a theme skin from the drop down list.",
        "id" => $shortname."_skin",
        "std" => "Dark",
		"options" => array('Dark', 'Light'),
        "type" => "select"),

		array(
		"name" => "Custom Logo URL",
        "desc" => "Enter your own logo image URL here (e.g. http://www.example.com/images/imagename.jpg)",
        "id" => $shortname."_logo_image",
        "std" => "",
        "type" => "text"),
       
        array(
		"name" => "Missing Large Thumbnail URL",
        "desc" => "If the post has no thumbnail you can display a default image instead (e.g. http://www.example.com/images/noimage.jpg).",
        "id" => $shortname."_no_thumb_large",
        "std" => "",
        "type" => "text"),
        
        array(
		"name" => "Missing Small Thumbnail URL",
        "desc" => "If the post has no thumbnail you can display a default image instead (e.g. http://www.example.com/images/noimage.jpg).",
        "id" => $shortname."_no_thumb_small",
        "std" => "",
        "type" => "text"),

		array(
		"name" => "Disable Search Bar",
        "desc" => "Checking this disables the search bar giving you more room for you logo and slogan.",
        "id" => $shortname."_disable_search",
        "std" => "false",
        "type" => "checkbox"),   
        
        array(
		"name" => "Favicon URL (.ico)",
        "desc" => "Type the URL of your favicon image (.ico, 16x16 or 32x32)",
        "id" => $shortname."_favicon_ico",
        "std" => "",
        "type" => "text"),

        array(
		"name" => "Favicon URL (.png)",
        "desc" => "Type the URL of your favicon image (.png, 16x16 or 32x32)",
        "id" => $shortname."_favicon_png",
        "std" => "",
        "type" => "text"),
        
         array(
		"name" => "Apple Icon URL (.png)",
        "desc" => "Type the URL of your apple icon image (.png, 57x57), used for display on the Apple iPhone",
        "id" => $shortname."_apple_icon",
        "std" => "",
        "type" => "text"),

		array(
		"name" => "RSS URL",
        "id" => $shortname."_rss",
        "std" => "",
        "type" => "text"),
        
        array(
		"name" => "Twitter URL",
        "id" => $shortname."_twitter",
        "std" => "",
        "type" => "text"),
        
        array(
		"name" => "Myspace URL",
        "id" => $shortname."_myspace",
        "std" => "",
        "type" => "text"),
        
        array(
		"name" => "Facebook URL",
        "id" => $shortname."_facebook",
        "std" => "",
        "type" => "text"),
        
        array(
		"name" => "Digg URL",
        "id" => $shortname."_digg",
        "std" => "",
        "type" => "text"), 
        
        array(
		"name" => "Linked In URL",
        "id" => $shortname."_linkedin",
        "std" => "",
        "type" => "text"),        
                
        array(
		"name" => "Flickr URL",
        "id" => $shortname."_flickr",
        "std" => "",
        "type" => "text"),

		array(
		"name" => "Scripts",
        "desc" => "Enter any scripts that need to be embedded into your theme (e.g. Google Analytics)",
        "id" => $shortname."_scripts",
        "std" => "",
        "type" => "textarea"),
        
		array("type" => "close"),	

array(	"name" => "Style Settings",
      	"type" => "title"),

		array(	"type" => "open",
      	"id" => $shortname."_style"),

		array(
		"name" => "Custom CSS",
        "desc" => "If you want to modify the theme style in some way add your own code here instead of editing the style sheets. <em>Note: You may have to add !important to your tags in some cases so it overwrites the default settings e.g. body {background: #000000 !important;}.</em>",
        "id" => $shortname."_custom_css",
        "std" => "",
        "type" => "textarea"),
        
        array(
		"name" => "Link Colour",
        "desc" => "Enter your colour code (e.g. #ff0000).",
        "id" => $shortname."_link_colour",
        "std" => "",
        "type" => "text"),
        
        array(
		"name" => "Link Hover Colour",
        "desc" => "Enter your colour code (e.g. #ff0000).",
        "id" => $shortname."_link_hover_colour",
        "std" => "",
        "type" => "text"),
        
        array(
		"name" => "Title Box Background Colour",
        "desc" => "Enter your colour code (e.g. #ff0000).",
        "id" => $shortname."_box_colour",
        "std" => "",
        "type" => "text"),

        array(
		"name" => "Alternative Title Box Background Colour",
        "desc" => "Enter you colour code (e.g. #ff0000).",
        "id" => $shortname."_alt_box_colour",
        "std" => "",
        "type" => "text"),

        array(
		"name" => "Transparent Background Colour",
        "desc" => "Enter your colour code (e.g. #ff0000).",
        "id" => $shortname."_transparent_bg_colour",
        "std" => "",
        "type" => "text"),
        
       array(
		"name" => "Page Background URL",
        "desc" => "Enter your own background URL here (e.g. http://www.example.com/images/bgname.jpg).",
        "id" => $shortname."_custom_bg",
        "std" => "",
        "type" => "text"),

		array(  
		"name" => "Page Background Repeat",
        "desc" => "Choose how your background is repeated.",
        "id" => $shortname."_custom_bg_repeat",
        "std" => "No Repeat",
		"options" => array('No Repeat', 'Repeat', 'Repeat Horizontally', 'Repeat Vertically'),
        "type" => "select"),

		array(
		"name" => "Header Background URL",
        "desc" => "Enter your own header background image URL here (e.g. http://www.example.com/images/imagename.jpg)",
        "id" => $shortname."_header_bg",
        "std" => "",
        "type" => "text"),        

		array(  
		"name" => "Header Background Repeat",
        "desc" => "Choose how your background is repeated.",
        "id" => $shortname."_header_bg_repeat",
        "std" => "No Repeat",
		"options" => array('No Repeat', 'Repeat', 'Repeat Horizontally', 'Repeat Vertically'),
        "type" => "select"),

		array(
		"name" => "Footer Background URL",
        "desc" => "Enter your own header background image URL here (e.g. http://www.example.com/images/imagename.jpg)",
        "id" => $shortname."_footer_bg",
        "std" => "",
        "type" => "text"),        

		array(  
		"name" => "Footer Background Repeat",
        "desc" => "Choose how your background is repeated.",
        "id" => $shortname."_footer_bg_repeat",
        "std" => "No Repeat",
		"options" => array('No Repeat', 'Repeat', 'Repeat Horizontally', 'Repeat Vertically'),
        "type" => "select"),

		array("type" => "close"),
		
array(	"name" => "Navigation Settings",
		"type" => "title"),

		array(  "type" => "open",
      	"id" => $shortname."_navigation"),

		array(
		"name" => "Header Pages To Exclude",
        "desc" => "Enter the IDs of the pages you want to exclude from the navigation menu, separating each with a comma (e.g. 23,51,102,65)",
        "id" => $shortname."_exclude_nav_pages",
        "std" => "",
        "type" => "text"),

		array(
		"name" => "Header Categories To Exclude",
        "desc" => "Enter the IDs of the categories you want to exclude from the navigation menu, separating each with a comma (e.g. 23,51,102,65)",
        "id" => $shortname."_exclude_nav_cats",
        "std" => "",
        "type" => "text"),

		array(
		"name" => "Footer Pages To Exclude",
        "desc" => "Enter the IDs of the pages you want to exclude from the navigation menu, separating each with a comma (e.g. 23,51,102,65)",
        "id" => $shortname."_exclude_footer_nav_pages",
        "std" => "",
        "type" => "text"),

		array(
		"name" => "Footer Categories To Exclude",
        "desc" => "Enter the IDs of the categories you want to exclude from the navigation menu, separating each with a comma (e.g. 23,51,102,65)",
        "id" => $shortname."_exclude_footer_nav_cats",
        "std" => "",
        "type" => "text"),
        
		array(
		"name" => "Hide \"Home\" Page Link",
        "desc" => "Checking this removes the \"Home\" page link from the navigation menu",
        "id" => $shortname."_show_home_nav",
        "std" => "false",
        "type" => "checkbox"),
        
        array(
		"name" => "Replace \"Home\" Link Text",
        "desc" => "Replace the \"Home\" text link with your own",
        "id" => $shortname."_home_text",
        "std" => "",
        "type" => "text"),
        
		array("type" => "close"),	
		
array(	"name" => "Homepage Settings",
      	"type" => "title"),

		array(	"type" => "open",
      	"id" => $shortname."_homepage"),

		array(  
		"name" => "Hide Homepage Content",
        "desc" => "Checking this removes all the content below the slider except the footer.",
        "id" => $shortname."_hide_homepage_content",
        "std" => "false",
        "type" => "checkbox"),

		array(  
		"name" => "Homepage Interface",
        "desc" => "Choose whether to display your posts with or without tabs.",
        "id" => $shortname."_homepage_interface",
        "std" => "Tabs",
		"options" => array('Tabs', 'No Tabs'),
        "type" => "select"),
        
		array(  
		"name" => "Number Of Posts Per Tab",
        "desc" => "Tabs are not paginated. Set to -1 if you do not want a limit. <em>Note: To control the number of posts per page elsewhere on the site go to Settings > Reading.</em>",
        "id" => $shortname."_number_of_posts",
        "std" => "10",
        "type" => "text"),
        
		array(  
		"name" => "Disable Featured Post Tab",
        "desc" => "Checking this disables the featured posts tab.",
        "id" => $shortname."_disable_featured_tab",
        "std" => "false",
        "type" => "checkbox"),

		array(  
		"name" => "Disable Latest Tab",
        "desc" => "Checking this disables the latest posts tab.",
        "id" => $shortname."_disable_latest_tab",
        "std" => "false",
        "type" => "checkbox"),

		array(  
		"name" => "Disable Most Comments Tab",
        "desc" => "Checking this disables the most commented posts tab.",
        "id" => $shortname."_disable_comments_tab",
        "std" => "false",
        "type" => "checkbox"),
        
		array("type" => "close"),	
		
array(	"name" => "Slider",
		"type" => "title"),

		array(  "type" => "open",
      	"id" => $shortname."_slider"),

		array(  
		"name" => "Slider Size",
        "desc" => "Choose between the large (980x525), medium (980x350) and small slider (780x418)",
        "id" => $shortname."_slider_size",
        "std" => "Large",
		"options" => array('Large', 'Medium', 'Small'),
        "type" => "select"),
        
		array(  
		"name" => "Show Slider On All Pages",
        "desc" => "Checking this shows the main slider on all pages",
        "id" => $shortname."_display_slider_all",
        "std" => "false",
        "type" => "checkbox"),

		array(  
		"name" => "Include On Specific Posts",
        "desc" => "Enter the IDs of the posts you want the slider to appear on, separating each with a comma (e.g. 23,51,102,65)",
        "id" => $shortname."_slider_posts",
        "type" => "text"),
        
        array(  
		"name" => "Include On Specific Pages",
        "desc" => "Enter the IDs of the pages you want the slider to appear on, separating each with a comma (e.g. 23,51,102,65)",
        "id" => $shortname."_slider_pages",
        "type" => "text"),
        
		array(  
		"name" => "Link Slider Images To Posts",
        "desc" => "Checking this makes the images in the sliders clickable, linking them to their posts",
        "id" => $shortname."_image_link",
        "std" => "false",
        "type" => "checkbox"),
        
        array(  
		"name" => "Disable Slider Description",
        "desc" => "Checking this disables the slide in description.",
        "id" => $shortname."_disable_slider_desc",
        "std" => "false",
        "type" => "checkbox"),

        array(  
		"name" => "Disable Slider Thumbnails",
        "desc" => "Checking this disables the slide in thumbnails.",
        "id" => $shortname."_disable_slider_thumbs",
        "std" => "false",
        "type" => "checkbox"),        

		array(
		"name" => "Disable Slider Controls",
        "desc" => "Checking this disables the resume and pause buttons.",
        "id" => $shortname."_disable_slider_controls",
        "std" => "false",
        "type" => "checkbox"), 

		array(  
		"name" => "Disable Auto Slide",
        "desc" => "Checking this disables the slides from changing to the next slide automatically",
        "id" => $shortname."_disable_autoslide",
        "std" => "false",
        "type" => "checkbox"),	
        
		array(  
		"name" => "Slider Speed",
        "desc" => "Enter the number of milliseconds delay between each slide, default value is 8000.",
        "id" => $shortname."_main_slider_speed",
        "std" => "8000",
        "type" => "text"),	
        
        array(  
		"name" => "Video Autostart",
        "desc" => "If the video is in the first slide it will autoplay.",
        "id" => $shortname."_autostart",
        "std" => "No",
		"options" => array('No', 'Yes'),
        "type" => "select"),
        
        array(  
		"name" => "Video Icons",
        "desc" => "Play/pause icons on the video display itself.",
        "id" => $shortname."_icons",
        "std" => "Yes",
		"options" => array('Yes', 'No'),
        "type" => "select"),

        array(  
		"name" => "Video Control Bar",
        "desc" => "Show or hide the control bar.",
        "id" => $shortname."_controlbar",
        "std" => "Hide",
		"options" => array('Hide', 'Show'),
        "type" => "select"),
        
        array(  
		"name" => "Video Quality",
        "desc" => "The quality of the video.",
        "id" => $shortname."_quality",
        "std" => "High",
		"options" => array('High', 'Low'),
        "type" => "select"),	

        array(  
		"name" => "Video Buffer Length",
        "desc" => "The number of seconds the video has to load before playing. <em>Note: If you use the auto slider set this to a low number so the video plays before the slider moves to the next slide.</em>",
        "id" => $shortname."_bufferlength",
        "std" => "1",
        "type" => "text"),
        
		array("type" => "close"),

array(	"name" => "Lightbox Video Settings",
		"type" => "title"),

		array(  "type" => "open",
      	"id" => $shortname."_lightbox"),
        
        array(  
		"name" => "FLV Video Autostart",
        "desc" => "The video will be played automatically when the lightbox opens.", 
        "id" => $shortname."_lb_autostart",
        "std" => "No",
		"options" => array('No', 'Yes'),
        "type" => "select"),
        
        array(  
		"name" => "FLV Video Icons",
        "desc" => "Play/pause icons on the video display itself.",
        "id" => $shortname."_lb_icons",
        "std" => "Yes",
		"options" => array('Yes', 'No'),
        "type" => "select"),

        array(  
		"name" => "FLV Video Control Bar",
        "desc" => "Show or hide the control bar.",
        "id" => $shortname."_lb_controlbar",
        "std" => "Hide",
		"options" => array('Hide', 'Show'),
        "type" => "select"),
        
        array(  
		"name" => "FLV Video Quality",
         "desc" => "The quality of the video.",
        "id" => $shortname."_lb_quality",
        "std" => "High",
		"options" => array('High', 'Low'),
        "type" => "select"),

        array(  
		"name" => "FLV Video Buffer Length",
        "desc" => "The number of seconds the video has to load before playing.",
        "id" => $shortname."_lb_bufferlength",
        "std" => "5",
        "type" => "text"),
        
		array("type" => "close"),

array(	"name" => "Blog Settings",
		"type" => "title"),

		array(	"type" => "open",
      	"id" => $shortname."_blog"),
        
		array(
		"name" => "Post Content Display",
        "desc" => "Choose whether to display the full post or an excerpt.",
        "id" => $shortname."_post_display",
        "std" => "Excerpt",
		"options" => array('Excerpt', 'Full Content'),
        "type" => "select"),

		array("type" => "close"),
		
array(	"name" => "Category Settings",
		"type" => "title"),

		array(	"type" => "open",
      	"id" => $shortname."_categories"),
      	
		array(
		"name" => "Alternative Category IDs",
        "desc" => "Enter the IDs of the categories that you want to use the alternative category template (e.g. 23,51,102,65).",
        "id" => $shortname."_alt_cat",
        "std" => "",
        "type" => "text"),

		array(
		"name" => "Category Header Image URL",
        "desc" => "Enter your own custom header image. <em>Note: By default the latest post in that specific category with the \"Featured Post\" option checked will display as the image header</em>.",
        "id" => $shortname."_alt_cat_image",
        "std" => "",
        "type" => "text"),
        
		array("type" => "close"),		

array(	"name" => "Portfolio Settings",
		"type" => "title"),

		array(	"type" => "open",
      	"id" => $shortname."_portfolio"),

        array(
		"name" => "Parent Page Link Title",
        "desc" => "Enter a custom title for your parent page portfolio link.",
        "id" => $shortname."_port_title",
        "std" => "",
        "type" => "text"),

        array(
		"name" => "Disable Pause On Hover",
        "desc" => "Checking this prevents the slider from pausing if you hover your mouse over it.",
        "id" => $shortname."_port_disable_pause",
        "type" => "checkbox",
        "std" => "false"),
        
        array(
		"name" => "Disable Auto rotation",
        "desc" => "Checking this disables the slider from changing to the next slider automatically",
        "id" => $shortname."_port_disable_rotation",
        "type" => "checkbox",
        "std" => "false"),
        
        array(
		"name" => "Time Between Slide",
        "desc" => "Enter the number of milliseconds you want between slides, the default is 4000.",
        "id" => $shortname."_port_between_speed",
        "type" => "text",
        "std" => "4000"),
        
        array(
		"name" => "Transition Speed",
        "desc" => "Enter the number of milliseconds you want for each transition, the default is 1500.",
        "id" => $shortname."_port_transition_speed",
        "type" => "text",
        "std" => "1500"),
        
		array("type" => "close"),
		
array(	"name" => "Footer Settings",
      	"type" => "title"),
        
		array(	"type" => "open",
      	"id" => $shortname."_footer"),

		array(
		"name" => "Footer Content",
        "desc" => "Enter the content you want to display in your footer.",
        "id" => $shortname."_footer_content",
        "std" => "",
        "type" => "textarea"),
        
		array("type" => "close"),

);

function mytheme_add_admin() {

    global $themename, $shortname, $options;

			
    if ( $_GET['page'] == basename(__FILE__) ) {

        if ( 'save' == $_REQUEST['action'] ) {

                foreach ($options as $value) {
                    update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }

                foreach ($options as $value) {
                    if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } }

                header("Location: themes.php?page=theme-options.php&saved=true");
                die;

        } else if( 'reset' == $_REQUEST['action'] ) {

            foreach ($options as $value) {
                delete_option( $value['id'] ); }

            header("Location: themes.php?page=theme-options.php&reset=true");
            die;

        }
    }

    add_theme_page($themename." Options", "".$themename." Options", 'edit_themes', basename(__FILE__), 'mytheme_admin');

}

function mytheme_admin() {

    global $themename, $shortname, $options;

    if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>Options Saved</strong></p></div>';
    if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>Options Reset</strong></p></div>';

?>

		
<?php
echo '<link rel="stylesheet" href="'.get_bloginfo('template_url').'/includes/admin/admin.css" type="text/css" media="screen" />';
echo '<script type="text/javascript" src="'.get_bloginfo('template_url').'/includes/admin/jquery.1.3.1.min.js"></script>
<script type="text/javascript" src="'.get_bloginfo('template_url').'/includes/admin/jquery.tabs.js"></script>';
?>

<div id="options_container" class="wrap">

<div id="options_header">
	
	<img src="<?php bloginfo('template_url'); ?>/includes/admin/logo.jpg" alt="" class="left" />
	
	<div id="option_links">
		<h2><?php echo $themename; ?> Options (<?php  $theme_data = get_theme_data(ABSPATH . 'wp-content/themes/magnifizine/style.css'); echo $theme_data['Version']; ?>)</h2>
		<a href="http://www.themeforest.net/user/GhostPool/portfolio" target="_blank">More Themes</a> |
		<a href="http://www.ghostpool.com/help/magnifizine/help.html" target="_blank">Documentation</a>
	</div>
	
	<form method="post">
		
	<div class="theme_buttons_top submit">	
		<input name="save" type="submit" value="Save changes" />
		<input type="hidden" name="action" value="save" />
	</div>

</div>

<div class="clear"></div>

    <ul class="idTabs">
        <li class="active"><a href="#theme_general">General Setting</a></li>
        <li><a href="#theme_style">Style Settings</a></li>
        <li><a href="#theme_navigation">Navigation Settings</a></li>
        <li><a href="#theme_homepage">Homepage Settings</a></li>
        <li><a href="#theme_slider">Slider Settings</a></li>
        <li><a href="#theme_lightbox">Lightbox Settings</a></li>
        <li><a href="#theme_blog">Blog Settings</a></li>
		<li><a href="#theme_categories">Category Settings</a></li>
        <li><a href="#theme_portfolio">Portfolio Settings</a></li>
        <li><a href="#theme_footer">Footer Settings</a></li>
    </ul>

<?php foreach ($options as $value) {
switch ( $value['type'] ) {
case "open":
?>
<div id="<?php echo $value['id']; ?>" class="option_panel">

<?php break;
case "close":
?>

</div>

<?php break;
case "title":
?>

<?php break;
case "divider":
?>
<div class="divider"></div>

<?php break;
case 'text':
?>

<div class="option">
<h3><?php echo $value['name']; ?></h3>
<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?>" class="theme_input" />
<div class="option_desc"><?php echo $value['desc']; ?></div>
</div>

<?php
break;

case 'textarea':
?>

<div class="option">
<h3><?php echo $value['name']; ?></h3>
<textarea name="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" cols="" rows="" class="theme_textarea"><?php if ( get_settings( $value['id'] ) != "") { echo stripslashes(get_settings( $value['id'] )); } else { echo $value['std']; } ?></textarea>
<div class="option_desc"><?php echo $value['desc']; ?></div>
</div>

<?php
break;

case 'select':
?>

<div class="option">
<h3><?php echo $value['name']; ?></h3>
<select class="theme_select" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>"><?php foreach ($value['options'] as $option) { ?><option value="<?php echo $option; ?>" <?php if ( get_settings( $value['id'] ) == $option) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option><?php } ?></select>
<div class="option_desc"><?php echo $value['desc']; ?></div>
</div>

<?php
break;

case "checkbox":
?>
   
<div class="option">
<h3><?php echo $value['name']; ?></h3>
<? if(get_settings($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = ""; } ?><input class="theme_checkbox" type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
<div class="theme_checkbox_desc"><?php echo $value['desc']; ?></div>
</div>

<?php        
break;

}
}
?>

<div class="clear"></div>

<div class="theme_buttons_bottom submit">
<input name="save" type="submit" value="Save changes" />
<input type="hidden" name="action" value="save" />
</form>

<form method="post">
<input name="reset" type="submit" value="Reset" />
<input type="hidden" name="action" value="reset" />
</form>
</div>

<div class="clear"></div>

<?php } add_action('admin_menu', 'mytheme_add_admin'); ?>