<?php

// Thumbnails
if (function_exists('add_theme_support')) {
add_theme_support('post-thumbnails');
get_option('thumbnail_crop');
add_image_size('slider-large', 980, 525, true);
add_image_size('slider-medium', 980, 350, true);
add_image_size('slider-small', 780, 418, true);
add_image_size('thumbnail', 123, 100, true);
add_image_size('portfolio-image', 560, 300, true);
add_image_size('alt-cat-image', 980, 300, true);
add_image_size('large-image', 640, 250, true);
add_image_size('sidebar-image', 280, 150, true);
}

// Main Theme Options
require_once(TEMPLATEPATH . '/includes/theme-options.php');

// Theme Post Options
require_once(TEMPLATEPATH . '/includes/theme-post-options.php');

// Widgets
require_once(TEMPLATEPATH . '/includes/theme-widgets.php');

// Sidebars
require_once(TEMPLATEPATH . '/includes/theme-sidebars.php');
        
// Shorten Text (Knowtebook.com)
function featured_small_title($text) {
	$chars_limit = 60;
	$chars_text = strlen($text);
	$text = $text." ";
	$text = substr($text,0,$chars_limit);
	$text = substr($text,0,strrpos($text,' '));
	if ($chars_text > $chars_limit) {
	$text = $text."...";
	}
	return $text;
}
function post_title($text) {
	$chars_limit = 40;
	$chars_text = strlen($text);
	$text = $text." ";
	$text = substr($text,0,$chars_limit);
	$text = substr($text,0,strrpos($text,' '));
	if ($chars_text > $chars_limit) {
	$text = $text."...";
	}
	return $text;
}
function thumb_title($text) {
	$chars_limit = 22;
	$chars_text = strlen($text);
	$text = $text." ";
	$text = substr($text,0,$chars_limit);
	$text = substr($text,0,strrpos($text,' '));
	if ($chars_text > $chars_limit) {
	$text = $text."...";
	}
	return $text;
}


// Comment Template
function comment_template($comment, $args, $depth) {
$GLOBALS['comment'] = $comment; ?>

<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
	
	<div id="comment-<?php comment_ID(); ?>" class="comment-body">
		
		<div class="comment-left">
			<?php echo get_avatar($comment,$size='60'); ?>
		</div>
			
		<div class="comment-text">
		
			<?php comment_text() ?>

			<div class="comment-meta">
				Posted by <?php printf(__('%s'), comment_author_link()) ?> on <?php comment_time('d F y'); ?> at <?php comment_time('g:ia'); ?> <?php comment_reply_link(array_merge( $args, array('reply_text' => '[Reply]', 'depth' => $depth, 'max_depth' => $args['max_depth']))); ?> <?php edit_comment_link('[Edit]','',''); ?> 		
			<?php if ($comment->comment_approved == '0') : ?>
			<div class="moderation">
				<?php _e('Your comment is awaiting moderation.') ?>
			</div>
			<?php endif; ?>
			</div>
			
		
		</div>
				
	</div>
	
<?php }

// Custom Excerpt Length
function excerpt($num)
{
$limit = $num+1;
$excerpt = explode(' ', get_the_excerpt(), $limit);
array_pop($excerpt);
$excerpt = implode(" ",$excerpt)."...";
echo $excerpt;
}

// Built-in WordPress Excerpt Length
if (function_exists('wp_page_menu')) {
function new_excerpt_length($length) {
	return 60; // Edit the excerpt length here
}
add_filter('excerpt_length', 'new_excerpt_length');
}

// Replace excerpt ellipsis with text linking to the post 
if (function_exists('wp_page_menu')) {
function new_excerpt_more($more) {
	return '...';
}
add_filter('excerpt_more', 'new_excerpt_more');
}

remove_filter('the_excerpt', 'wpautop');

// Paginate offsetted post queries
function my_post_limit($limit) {
	global $paged, $myOffset;
	if (empty($paged)) {
			$paged = 1;
	}
	$postperpage = intval(get_option('posts_per_page'));
	$pgstrt = ((intval($paged) -1) * $postperpage) + $myOffset . ', ';
	$limit = 'LIMIT '.$pgstrt.$postperpage;
	return $limit;
}

// Hide No Categories Message
function hide_cat_display($content) {
if (!empty($content)) {
$content = str_replace('<li>' .__( "No categories" ). '</li>', "", $content);
}
return $content;
}
add_filter('wp_list_categories','hide_cat_display');

?>